/// Enigma API implementation
using System;
using System.Text;
using System.Runtime.InteropServices;

/// <summary>
/// Summary description for Enigma_IDE
/// </summary>
public class Enigma_IDE
{

    public struct TWMContent
    {
        public Int32 WMType;
        public string Name;
        public Int32 NameLen;
        public string Text;
        public Int32 TextLen;
        public string FileName;
        public Int32 FileNameLen;
        public string AFile;
        public Int32 AFileLen;
    }

    // Enigma API for registration
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_RegSaveKey(string Name, string Key);
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_RegLoadKey(ref string Name, ref string Key);
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_RegCheckKey(string Name, string Key);
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_RegDeleteKey();
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_RegLoadAndCheckKey();
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_RegCheckAndSaveKey(string Name, string Key);
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern string EP_RegHardwareID();
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_RegKeyCreationDate(ref Int32 Year, ref Int32 Month, ref Int32 Day);
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_RegKeyExpirationDate(ref Int32 Year, ref Int32 Month, ref Int32 Day);

    // Enigma API for trial
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_TrialExecutions(ref Int32 Total, ref Int32 Left);
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_TrialDays(ref Int32 Total, ref Int32 Left);
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_TrialExpirationDate(ref Int32 Year, ref Int32 Month, ref Int32 Day);
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_TrialDateTillDate(ref Int32 StartYear, ref Int32 StartMonth, ref Int32 StartDay, ref Int32 EndYear, ref Int32 EndMonth, ref Int32 EndDay);
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern bool EP_TrialExecutionTime(ref Int32 Total, ref Int32 Left);

    // Misc API
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern Int32 EP_MiscGetWatermark(Int32 ID, TWMContent WM);

    // Protection API
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern Int32 EP_ProtectedStringByID(Int32 ID, StringBuilder Str, Int32 Len);
    [DllImport("enigma_ide.dll", CallingConvention = CallingConvention.StdCall)]
    public static extern Int32 EP_ProtectedStringByKey(string Key, StringBuilder Str, Int32 Len);
}
